DROP PROCEDURE [hips].[SuffixInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 30 October 2012
-- Description:   Inserts a new record into the Suffix Table
-- =============================================

CREATE PROCEDURE [hips].[SuffixInsert] 
(
	@Code VARCHAR(10),
	@Description VARCHAR(10),
	@UserModified VARCHAR(256)
) 
AS
BEGIN
	SET NOCOUNT ON

   DECLARE @intErrorCode INT
          , @SuffixId INT
    SELECT   @SuffixId = SuffixId 
    FROM [hips].Suffix WHERE Code = @Code      
    SET @intErrorCode = 0
    IF (@SuffixId IS NULL)
    BEGIN
		INSERT INTO [hips].[Suffix]
				( Code,
				  Description,
				  DateCreated,
				  UserCreated,
				  DateModified,
				  UserModified
				)
		VALUES  ( @Code,
				  @Description,
				  GETDATE(), 
				  @UserModified, 
				  GETDATE(), 
				  @UserModified  
				)
		        
		 SELECT @intErrorCode = @@ERROR , @SuffixId = SCOPE_IDENTITY()
	END
    IF @intErrorCode = 0
    BEGIN
		SELECT t.SuffixId
			,t.Code
			,t.Description
		    ,t.DateCreated
			,t.UserCreated
			,t.DateModified
			,t.UserModified
		FROM hips.Suffix t
		WHERE @SuffixId = t.SuffixId
    END

    RETURN(@intErrorCode)

	

END
GO

